@extends('adminlte::page')

@section('title', 'Tambah Member')

@section('content_header')
    <h1>Tambah Member</h1>
@stop

@section('content')
<form action="{{ route('members.store') }}" method="POST">
    @csrf
    <div class="mb-3">
        <label>Nama</label>
        <input type="text" name="nama" class="form-control" value="{{ old('nama') }}" maxlength="18" required>
        @error('nama') <span class="text-danger" >{{ $message }}</span> @enderror
    </div>
    <div class="mb-3">
        <label>Kontak</label>
        <input type="text" name="kontak" class="form-control" value="{{ old('kontak') }}" maxlength="13" required>
        @error('kontak') <span class="text-danger">{{ $message }}</span> @enderror
    </div>
    <div class="mb-3">
        <label>Alamat</label>
        <textarea name="alamat" class="form-control" maxlength="47" required>{{ old('alamat') }}</textarea>
        @error('alamat') <span class="text-danger">{{ $message }}</span> @enderror
    </div>
    <div class="mb-3">
        <label>Expired At</label>
        <input type="date" name="expired_at" class="form-control" value="{{ old('expired_at') }}">
        @error('expired_at') <span class="text-danger">{{ $message }}</span> @enderror
    </div>
    <button type="submit" class="btn btn-primary">Simpan</button>
    <a href="{{ route('members.index') }}" class="btn btn-secondary">Batal</a>
</form>
@endsection
